/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.ultimatestack.network;

import com.porpit.ultimatestack.config.ConfigLoader;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageItemConfig
implements IMessage {
    Map<String, Short> itemMaxStackSizeMap;

    public MessageItemConfig() {
    }

    public MessageItemConfig(Map<String, Short> itemMaxStackSizeMap) {
        this.itemMaxStackSizeMap = itemMaxStackSizeMap;
    }

    public void fromBytes(ByteBuf buf) {
        int count = buf.readInt();
        this.itemMaxStackSizeMap = new HashMap<String, Short>();
        for (int i = 0; i < count; ++i) {
            int itemID = buf.readInt();
            int metaData = buf.readInt();
            short maxSize = buf.readShort();
            this.itemMaxStackSizeMap.put(Item.func_150899_d((int)itemID).getRegistryName() + ":" + metaData, maxSize);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemMaxStackSizeMap.size());
        this.itemMaxStackSizeMap.forEach((key, value) -> {
            String[] nameAndMeta = key.split(":");
            String itemID = nameAndMeta[0];
            for (int i = 1; i < nameAndMeta.length - 1; ++i) {
                itemID = itemID + ":" + nameAndMeta[i];
            }
            int metaData = Integer.valueOf(nameAndMeta[nameAndMeta.length - 1]);
            int itemIntID = Item.func_150891_b((Item)Item.func_111206_d((String)itemID));
            buf.writeInt(itemIntID);
            buf.writeInt(metaData);
            buf.writeShort((int)value.shortValue());
        });
    }

    public static class Handler
    implements IMessageHandler<MessageItemConfig, IMessage> {
        public IMessage onMessage(MessageItemConfig message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> ConfigLoader.loadItemDataFormServer(message.itemMaxStackSizeMap));
                System.out.println("test");
                ConfigLoader.isServerSuport = true;
            }
            return null;
        }
    }
}

